/*
 * Decompiled with CFR 0.152.
 */
package levosilimo.everlastingskins.skinchanger;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import levosilimo.everlastingskins.enums.SkinVariant;
import levosilimo.everlastingskins.skinchanger.MojangSkinProvider;
import levosilimo.everlastingskins.util.RandomUserAgent;

public class RandomMojangSkin {
    private static final List<String> BLACK_LIST = List.of("ad");
    private static final int MIN_SKIN_INDEX = 9000;
    private static final int MAX_SKIN_INDEX = 40000;
    private static final String SPAN_TEXT = "<span class=\"card-title green-text truncate\">";
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
    private static final JsonParser parser = new JsonParser();

    public static String randomNickname(boolean needCape, SkinVariant variant, boolean latest) {
        String url;
        if (latest) {
            url = "https://mskins.net/ru/skins/latest";
        } else if (needCape) {
            Random rand = new Random();
            int year = rand.nextInt(6) + 2011;
            while (year == 2014) {
                year = rand.nextInt(6) + 2011;
            }
            int page = rand.nextInt(24) + year % 10 * 5 + 1;
            url = String.format("https://mskins.net/en/cape/minecon_%d?page=%d", year, page);
        } else {
            url = "https://mskins.net/en/skins/random";
        }
        String html = RandomMojangSkin.getHtmlFromUrl(url);
        if (html.length() < 20000) {
            return "Notch";
        }
        HashSet<String> nicknames = new HashSet<String>();
        int charPointer = 9000;
        int randomSkinIndex = -1;
        while (charPointer <= 40000 && (randomSkinIndex = html.indexOf(SPAN_TEXT, charPointer) + SPAN_TEXT.length()) > 44) {
            charPointer = randomSkinIndex + 1;
            int randomUsernameIndexEnd = html.indexOf("<", randomSkinIndex);
            if (randomUsernameIndexEnd == -1) break;
            nicknames.add(html.substring(randomSkinIndex, randomUsernameIndexEnd));
        }
        if (nicknames.isEmpty()) {
            return "Notch";
        }
        Stack<String> nicknamesStack = new Stack<String>();
        nicknamesStack.addAll(nicknames);
        Collections.shuffle(nicknamesStack);
        String nickname = "Notch";
        while (!nicknamesStack.isEmpty()) {
            nickname = (String)nicknamesStack.pop();
            while ((nickname.isEmpty() || BLACK_LIST.contains(nickname)) && !nicknamesStack.isEmpty()) {
                nickname = (String)nicknamesStack.pop();
            }
            if (needCape && !RandomMojangSkin.hasCape(nickname) || variant == SkinVariant.slim && !RandomMojangSkin.isSlim(nickname) || variant == SkinVariant.classic && RandomMojangSkin.isSlim(nickname)) continue;
        }
        return nickname;
    }

    private static String getHtmlFromUrl(String url) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(url)).header("User-Agent", RandomUserAgent.getRandomUserAgent()).GET().build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body();
        }
        catch (IOException | InterruptedException | URISyntaxException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static boolean hasCape(String nick) {
        String decodedSTR = new String(Base64.getDecoder().decode(MojangSkinProvider.getSkin(nick).getValue()));
        JsonObject decodedJSON = parser.parse(decodedSTR).getAsJsonObject();
        return decodedJSON.getAsJsonObject("textures").has("CAPE");
    }

    public static boolean isSlim(String nick) {
        String decodedSTR = new String(Base64.getDecoder().decode(MojangSkinProvider.getSkin(nick).getValue()));
        JsonObject decodedJSON = parser.parse(decodedSTR).getAsJsonObject();
        return decodedJSON.getAsJsonObject("textures").getAsJsonObject("SKIN").has("metadata");
    }
}

